#!/usr/bin/env python
# coding: utf-8

import numpy as np

def Cllr(tar_llrs, nontar_llrs):
    """Return Cllr for the supplied array of likelihood ratios.
    
    :param: tar_llrs: array of LRs for target (M).
    :param: nontar_llrs: array of LRs for non-target (F).
    """
    return (
        np.log2(1 + 1/tar_llrs).sum()    / len(tar_llrs)    + \
        np.log2(1 +   nontar_llrs).sum() / len(nontar_llrs)
    ) / 2


