#!/usr/bin/env python
# coding: utf-8

import matplotlib.pyplot as plt
import numpy as np
import pandas as pd


def plot_tippett(tar_llrs, nontar_llrs, xlim=None, title=None):
    """Show Tippett plot for the supplied array of likelihood ratios.
    
    :param: tar_llrs: array of LRs for target (M).
    :param: nontar_llrs: array of LRs for non-target (F).
    :param: xlim: X axis limits
    :param: title: Title for the plot
    """
    y_f =     np.arange(1, len(tar_llrs) + 1)/len(tar_llrs)
    y_m = 1 - np.arange(len(nontar_llrs))/len(nontar_llrs)
    x_f =     np.sort(np.log10(tar_llrs))
    x_m =     np.sort(np.log10(nontar_llrs))
    
    fig, ax = plt.subplots(figsize=(8, 6))
    ax.grid()
    ax.plot(x_f, y_f, color='b')
    ax.plot(x_m, y_m, color='r')
    ax.plot(x_f, y_f, '.', color='b')
    ax.plot(x_m, y_m, '.', color='r')

    _ = ax.plot([0, 0], [0, 1], ':')

    ax.set_xlabel("Log10 Likelihood Ratio")
    ax.set_ylabel("Cumulative Proportion")

    ax.set_xlim(xlim)
    ax.set_ylim([0, 1])
    ax.set_title(title)
    y_ticks = [round(ii, 2) for ii in np.arange(0, 1.1, 0.1)]
    ax.set_yticks(y_ticks)
    ax.set_yticklabels(y_ticks)
